#define ARRAY_SIZE 12 // Dimension des tableaux des LED
int pinArray[ARRAY_SIZE] = {2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
boolean pinBlinkArray[ARRAY_SIZE]; // Tableau des clignotements
int pin, level;      // Numéro de broche et niveau
char mode;           // Mode numérique ou analogique
int interval = 1000; // Durée du clignotement
unsigned long prev;  // Variable de temps
int ledStatus = LOW; // État du clignotement

void setup() {
  Serial.begin(38400);
  for(int i = 0; i < ARRAY_SIZE; i++)
    pinMode(pinArray[i], OUTPUT);
  for(int i = 0; i < ARRAY_SIZE; i++)
    pinBlinkArray[i] = false;
}

void loop() {
  readSerial(); // Appel à la fonction d'acquisition
}

void readSerial() {
  if(Serial.available() > 0) {
    while (Serial.peek() == 'S') {  // Attente du caractère de départ
      Serial.read();                // S (start) lecture du flux dans le tampon série
      pin = Serial.parseInt();      // Extraction du numéro de broche
      mode = Serial.read();         // Extraction du mode
      level = Serial.parseInt();    // Extraction du niveau
      if(mode == 'D') {             // Traitement du mode digital D
        pinBlinkArray[pin - 2] = false; // Arrêt du clignotement
        digitalWrite(pin, level);       // Commande de la LED
      }
      if(mode == 'A') {             // Traitement du mode analogique A
        pinBlinkArray[pin - 2] = false; // Arrêt du clignotement
        analogWrite(pin, level);        // Commande de la LED
      }
      if(mode == 'B')                // Traitement du mode clignotement B
        pinBlinkArray[pin - 2] = level; // Mémorisation du clignotement
    }
    while (Serial.available() > 0){ // Vider le tampon série
      Serial.read();
    }
  }
  // Clignotement
  if((millis() - prev) > interval) {
    prev = millis();
    ledStatus = !ledStatus; // Inversion du statut
    for(int i = 0; i < ARRAY_SIZE; i++) {
      if(pinBlinkArray[i] == true)
        digitalWrite(pinArray[i], ledStatus);  
    }    
  }
}
